/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package proc.rss;

import data.base.NoBaseException;

import javax.swing.JTextField;

import data.structures.rss.RSSFeedInfoExtended;

public class Collecteur extends Thread {

    private String etat = "pas de lecture en cours";
    private String erreur = "";
    private String reussite = "";
    private boolean enCours = false;
    private int derniereCollecte = 0;
    private long dernierDepart = 0;
    private boolean running = false;
    private boolean stop = false;
    private boolean plante = false;
    private RSSSaver collecteur;
    private RSSFeedInfoExtended flux;
    private JTextField delai;

    public Collecteur(RSSSaver collecteur, RSSFeedInfoExtended flux, JTextField delai) {
        this.collecteur = collecteur;
        this.flux = flux;
        this.delai = delai;
    }

    @Override
    public void run() {
        while (running) {
            try {
                dernierDepart = System.currentTimeMillis();
                etat = "lecture en cours ";
                enCours = true;
                derniereCollecte = collecteur.readFeed(flux);
                if (derniereCollecte == -1) {
                    erreur = collecteur.getReadErrorMessage();
                    reussite = "";
                } else {
                    reussite = collecteur.getReadSuccessMessage();
                    erreur = "";
                }
                etat = "<i>lecture terminée </i>";
                enCours = false;
                Thread.sleep(60000 * Integer.parseInt(delai.getText()));
            } catch (InterruptedException ie) {
                // C'est reparti !
            } catch(NoBaseException nbe){
                try {
                    Thread.sleep(60000 * Integer.parseInt(delai.getText()));
                } catch (InterruptedException ie) {
                    // C'est reparti !
                }
            }
        }
        stop = true;
    }

    @Override
    public void start() {
        running = true;
        super.start();
    }

    public void fin() {
        running = false;
        interrupt();
    }

    public void setPlante(boolean plante){
        this.plante = plante;
    }

    public boolean isRunning() {
        return running;
    }

    public boolean isEnTrainDeLire() {
        return enCours;
    }

    public boolean isStopped() {
        return stop;
    }

    public long getTemps() {
        long elapsed = enCours?(System.currentTimeMillis() - dernierDepart):0;
        return elapsed;
    }

    public RSSSaver getCollecteur() {
        return collecteur;
    }

    public RSSFeedInfoExtended getFlux() {
        return flux;
    }

    @Override
    public String toString() {
        long elapsed = System.currentTimeMillis() - dernierDepart;
        String hr = "" + (elapsed / 3600000);
        if (hr.length() < 2) {
            hr = "0" + hr;
        }
        String mn = "" + (elapsed % 3600000 / 60000);
        if (mn.length() < 2) {
            mn = "0" + mn;
        }
        String s = "" + (elapsed % 60000 / 1000);
        if (s.length() < 2) {
            s = "0" + s;
        }
        if (stop || plante) {
            return "<html>" + flux.name + " : <i>arrêté pour cause de lecture trop longue</i> - " + hr + ":" + mn + ":" + s + ".";
        }
        if (enCours) {
            
            String ss = "";
            if (derniereCollecte == -1) {
                ss = "<b>erreur de collecte</b> (<i>" + erreur + "</i>).";
            } else if (derniereCollecte == 0) {
                ss = "rien de nouveau (<i>" + reussite + "</i>).";
            } else {
                ss = "<b>" + derniereCollecte + " entrée" + (derniereCollecte > 1 ? "s" : "") + " à traiter</b> (<i>" + reussite + "</i>).";
            }
            if (elapsed < 300000) {
                return "<html>" + flux.name + " : " + ss + " - " + etat + " - " + hr + ":" + mn + ":" + s + ".";
            } else {
                return "<html><font color=\"#800000\">" + flux.name + " : " + ss + " - " + etat + " - " + hr + ":" + mn + ":" + s + ".";
            }
        } else {
            if (derniereCollecte == -1) {
                return "<html>" + flux.name + " : <font color=\"#800000\"><b>erreur de collecte</b></font> (<i>" + erreur + "</i>).";
            } else if (derniereCollecte == 0) {
                return "<html>" + flux.name + " : rien de nouveau (<i>" + reussite + "</i>).";
            } else {
                return "<html>" + flux.name + " : <b>" + derniereCollecte + " entrée" + (derniereCollecte > 1 ? "s" : "") + " à traiter.</b> (<i>" + reussite + "</i>)";
            }
        }
    }
}
